	clear all
	clc
	%	Compare filters
	% Fig. 7.9a
	Wc = 20000;
	Ws = 28000;
	Amax = 0.28029;
	Amin = 40;
	lw = 2;
	fs = 16;
	fn = 'times'; 
	axis([0, 100000, 0, 80]);
	subplot('position', [0.08 0.4 0.90 0.5]);
	W = [0:20:100000];
	N = 18;
	[G, Z, R_ZEROS, P, Wsnew] = BW_POLES_S(Wc, Ws, Amax, Amin, N);
	H = PZ_2_FREQ_S(G, Z, P, W);
	Att = MAG_2_ATT(H);
	plot(W, Att,'linewidth',lw);
	hold on

	N = 8;
	[G, Z, R_ZEROS, P, Wsnew] = CH_I_POLES_S(Wc, Ws, Amax, Amin, N);
	H = PZ_2_FREQ_S(G, Z, P, W);
	Att = MAG_2_ATT(H);
	plot(W, Att,'linewidth',2,'color','r');
	[G, Z, R_ZEROS, P, Wsnew] = CH_II_POLES_S(Wc, Ws, Amax, Amin, N);
	H = PZ_2_FREQ_S(G, Z, P, W);
	Att = MAG_2_ATT(H);
	plot(W, Att,'linewidth',2);

	N = 5;
	[G, Z, Zr, P, Wnew] = CA_POLES_S(Wc, Ws, Amax, Amin, N);
	H = PZ_2_FREQ_S(G, Z, P, W);
	Att = MAG_2_ATT(H);
	plot(W, Att,'linewidth',lw);
	 
	grid on	
	set(gca,'FontName', fn,'FontSize', fs);
	xlabel('{\it\omega}   [rad/s]','FontName','times','FontSize',fs);
	ylabel('{\itA}({\it\omega})   [dB]','FontName','times','FontSize',fs);
 	axis([0, 100000, 0, 80]);
